/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.io.BitConstants;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends OutputStream
implements BitConstants {
    private OutputStream os;
    private int requestedNumberOfBits;
    private int bitMask;
    private int data = 0;
    private int bitsOfData = 0;

    public BitOutputStream(OutputStream os, int startingNumberOfBits) {
        this.os = os;
        this.setRequestedNumberOfBits(startingNumberOfBits);
    }

    public void setRequestedNumberOfBits(int numberOfBits) {
        this.requestedNumberOfBits = numberOfBits;
        this.bitMask = BIT_MASKS[numberOfBits];
    }

    public void increaseRequestedNumberOfBits() {
        this.setRequestedNumberOfBits(this.requestedNumberOfBits + 1);
    }

    public int getBitMask() {
        return this.bitMask;
    }

    @Override
    public void write(int b) throws IOException {
        b &= this.bitMask;
        this.data |= (b <<= this.bitsOfData);
        this.bitsOfData += this.requestedNumberOfBits;
        while (this.bitsOfData >= 8) {
            this.os.write(this.data & 0xFF);
            this.data >>= 8;
            this.bitsOfData -= 8;
        }
    }

    public void clearRemainingBitsOfData() {
        this.bitsOfData = 0;
        this.data = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.bitsOfData > 0) {
            this.write(0);
        }
    }
}

